//
//  table__c_m_a_p.h
//  GSFontTools
//
//  Created by Georg Seifert on 24.07.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <GSFontTools/TTable.h>
#import <GSFontTools/table__n_a_m_e.h>

@class TTFont;
//@class MGOrderedDictionary;
@class TTCmapSubtable;

@interface table__c_m_a_p : TTable {
	NSMutableArray<TTCmapSubtable *> *_subTables;
	Fixed _tableVersion;
}

@property (assign, nonatomic) Fixed tableVersion;
@property (readonly) NSArray<TTCmapSubtable *> *subTables;

- (TTCmapSubtable *)cmapForPlatformID:(GSNamePlatform)platformID platEncID:(GSNameEncoding)platEncID;
- (TTCmapSubtable *)bestCmap;
- (void)addSubtable:(TTCmapSubtable *)subTable;
- (void)sortSubtables;
@end

@interface TTCmapSubtable : NSObject {
	uint16_t _format;
	NSUInteger _length;
	NSUInteger _platformID;
	NSUInteger _platEncID;
	NSUInteger _languageID;
	NSData *_data;
	TTFont *_font;
	NSMutableDictionary *_cmap;
}
@property (nonatomic) uint16_t format;
@property (nonatomic) NSUInteger platformID;
@property (nonatomic) NSUInteger platEncID;
@property (nonatomic) NSUInteger languageID;
@property (retain, nonatomic) NSMutableDictionary *cmap;
@property (retain, nonatomic) NSData *data;

- (id)initWithFormat:(NSUInteger)format;
- (BOOL)decompileHeader:(NSData *)data font:(TTFont *)font error:(NSError **)error;
- (BOOL)decompile:(NSData *)data font:(TTFont *)font error:(NSError **)error;
- (NSData *)compile:(TTFont *)font error:(NSError **)error;

- (void)toXML:(GSXMLWriter *)writer font:(TTFont *)font;

- (void)_writeCodes:(NSMutableDictionary *)codes writer:(GSXMLWriter *)writer;

- (void)fromXML:(NSString *)name attrs:(NSDictionary *)attrs content:(id)content font:(TTFont *)font;

- (BOOL)isUnicode;

- (NSIndexSet *)indexSet;

@end

@interface cmap_format_0 : TTCmapSubtable {}
@end

@interface cmap_format_2 : TTCmapSubtable {}
@end

@interface cmap_format_4 : TTCmapSubtable {}
@end

@interface cmap_format_6 : TTCmapSubtable {}
@end
@interface cmap_format_12 : TTCmapSubtable {
	NSUInteger _nGroups;
}
@end
@interface cmap_format_14 : TTCmapSubtable {
	NSUInteger _numVarSelectorRecords;
}
@property (strong, nonatomic) NSDictionary *uvsDict;

@end
@interface cmap_format_unknown : TTCmapSubtable {}
@end
